'use strict';

/* --------------------------------------------------------------
 add_category_to_product.js 2015-10-01
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2015 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * ## Adds a category dropdown to the categories box by clicking on the add button
 *
 * @module Controllers/add_category_to_product
 */
gx.controllers.module('add_category_to_product', [],

/** @lends module:Controllers/add_category_to_product */

function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLE DEFINITION
    // ------------------------------------------------------------------------

    var
    /**
     * Module Selector
     *
     * @var {object}
     */
    $this = $(this),


    /**
     * Default Options
     *
     * @type {object}
     */
    defaults = {},


    /**
     * Final Options
     *
     * @var {object}
     */
    options = $.extend(true, {}, defaults, data),


    /**
     * Module Object
     *
     * @type {object}
     */
    module = {};

    // ------------------------------------------------------------------------
    // EVENT HANDLERS
    // ------------------------------------------------------------------------

    /**
     * add category dropdown when clicking add button
     *
     * @private
     */
    var _addCategory = function _addCategory() {
        var $newCategory = $this.find('.category-template').clone().removeClass('category-template').addClass('category-link-wrapper').removeClass('hidden');

        $this.find('.category-link-wrapper:last').removeClass('remove-border').after($newCategory);

        $newCategory.find('select').prop('disabled', false).on('change', _changeCategory);
    };

    /**
     * update displayed category path on dropdown change event
     *
     * @private
     */
    var _changeCategory = function _changeCategory() {
        var level = ($(this).find('option:selected').html().match(/&nbsp;/g) || []).length;
        var categories = [];

        if (level > 0) {
            categories.unshift($(this).find('option:selected').html().replace(/&nbsp;/g, ''));
        }

        if (level > 3) {
            $(this).find('option:selected').prevAll().each(function () {
                if (($(this).html().match(/&nbsp;/g) || []).length === level - 3 && level > 3) {
                    level -= 3;
                    categories.unshift($(this).html().replace(/&nbsp;/g, ''));
                }
            });
        }

        $(this).parents('.category-link-wrapper').find('.category-path').html(categories.join(' > '));
    };

    /**
     * Update displayed categories list for multi select on change event.
     *
     * @private
     */
    var _changeCategoryMultiSelect = function _changeCategoryMultiSelect() {
        var level,
            processedLevel,
            categories = [],
            categoryPathArray = [],
            selected = $(this).find('option:selected'),
            $multiSelectContainer = $('.multi-select-container').parent();

        $.each(selected, function () {
            level = ($(this).html().match(/&nbsp;/g) || []).length;
            processedLevel = level;
            if (level > 0) {
                categoryPathArray = [];
                categoryPathArray.unshift($(this).html().replace(/&nbsp;/g, ''));

                $(this).prevAll().each(function () {
                    if (($(this).html().match(/&nbsp;/g) || []).length === processedLevel - 3 && processedLevel > 3) {

                        processedLevel -= 3;
                        categoryPathArray.unshift($(this).html().replace(/&nbsp;/g, ''));
                    }
                });
                categories.push(categoryPathArray);
            }
        });

        $multiSelectContainer.empty();
        if (categories.length > 0) {
            $.each(categories, function () {
                $multiSelectContainer.append('<div class="span12 multi-select-container">' + '<label class="category-path">' + this.join(' > ') + '</label></div>');
            });
        } else {
            $multiSelectContainer.append('<div class="span12 multi-select-container"></div>');
        }
    };

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    /**
     * Init function of the widget
     */
    module.init = function (done) {
        var select = $this.find('select');
        $this.find('.add-category').on('click', _addCategory);

        if (select.prop('multiple')) {
            select.on('change', _changeCategoryMultiSelect);
            //select.on('change', _changeCategory);
        } else {
            select.on('change', _changeCategory);
        }

        done();
    };

    // Return data to widget engine
    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
